/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.reward;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.quests.adapters.AssemblyFunctionAdapter;
import dev.toma.gunsrpg.common.quests.reward.IAssemblyFunction;
import dev.toma.gunsrpg.common.quests.reward.IQuestItemProvider;
import dev.toma.gunsrpg.common.quests.reward.IQuestRewardResolver;
import dev.toma.gunsrpg.common.quests.reward.QuestRewardList;
import dev.toma.gunsrpg.common.quests.reward.RewardProviderType;
import dev.toma.gunsrpg.resource.SingleJsonFileReloadListener;
import dev.toma.gunsrpg.resource.adapter.CountFunctionAdapter;
import dev.toma.gunsrpg.resource.crate.ICountFunction;
import dev.toma.gunsrpg.util.ILogHandler;
import dev.toma.gunsrpg.util.ModUtils;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class QuestRewardManager
extends SingleJsonFileReloadListener {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(ICountFunction.class, (Object)CountFunctionAdapter.positive()).registerTypeHierarchyAdapter(IAssemblyFunction.class, (Object)new AssemblyFunctionAdapter()).create();
    private final ILogHandler logger;
    private final Int2ObjectMap<QuestRewardList> rewardTierMap = new Int2ObjectOpenHashMap();

    public QuestRewardManager(ILogHandler logger) {
        super(GunsRPG.makeResource("quest/rewards.json"), GSON);
        this.logger = logger;
    }

    public QuestRewardList getTieredRewards(int tier) {
        return ModUtils.getNonnullFromMap(this.rewardTierMap, tier, QuestRewardList.EMPTY_LIST);
    }

    protected void apply(JsonElement element, IResourceManager manager, IProfiler profiler) {
        this.logger.info("Loading quest reward list", new Object[0]);
        this.rewardTierMap.clear();
        try {
            this.loadRewardsFromJson(element);
            this.logger.info("Quest rewards loaded", new Object[0]);
        }
        catch (JsonParseException e) {
            this.logger.err("Quest reward loading failed: " + e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            this.logger.fatal("Fatal error while loading quest rewards: " + e, new Object[0]);
        }
    }

    private void loadRewardsFromJson(JsonElement element) throws JsonParseException {
        JsonObject object = JsonHelper.asJsonObject(element);
        Map<String, ItemGroup> itemGroupMap = this.loadItemGroups(JSONUtils.func_151214_t((JsonObject)object, (String)"itemGroups"));
        JsonArray array = JSONUtils.func_151214_t((JsonObject)object, (String)"rewards");
        for (JsonElement tieredRewards : array) {
            this.loadTieredRewards(tieredRewards, itemGroupMap);
        }
    }

    private void loadTieredRewards(JsonElement element, Map<String, ItemGroup> map) throws JsonParseException {
        JsonObject object = JsonHelper.asJsonObject(element);
        int tier = JSONUtils.func_151203_m((JsonObject)object, (String)"tier");
        JsonArray array = JSONUtils.func_151214_t((JsonObject)object, (String)"items");
        IQuestItemProvider[] itemProviders = JsonHelper.deserializeInto(array, IQuestItemProvider[]::new, json -> {
            JsonObject provider = JsonHelper.asJsonObject(json);
            ResourceLocation type = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)provider, (String)"type"));
            RewardProviderType providerType = RewardProviderType.getById(type);
            if (providerType == null) {
                throw new JsonSyntaxException("Unknown reward type: " + type);
            }
            IQuestRewardResolver resolver = providerType.getResolver();
            int count = JSONUtils.func_151208_a((JsonObject)provider, (String)"count", (int)1);
            int weight = JSONUtils.func_151208_a((JsonObject)provider, (String)"weight", (int)1);
            IAssemblyFunction[] functions = provider.has("assemblyFunctions") ? QuestRewardManager.loadFunctions(JSONUtils.func_151214_t((JsonObject)provider, (String)"assemblyFunctions")) : null;
            return resolver.resolve(provider, providerType, count, weight, functions, map);
        });
        QuestRewardList list = new QuestRewardList(itemProviders);
        this.rewardTierMap.put(tier, (Object)list);
    }

    private Map<String, ItemGroup> loadItemGroups(JsonArray array) throws JsonParseException {
        ItemGroup[] groups = JsonHelper.deserializeInto(array, ItemGroup[]::new, ItemGroup::resolve);
        HashMap<String, ItemGroup> map = new HashMap<String, ItemGroup>();
        for (ItemGroup group : groups) {
            ItemGroup prev = map.put(group.id, group);
            if (prev == null) continue;
            this.logger.warning("Duplicate item group: " + group.id, new Object[0]);
        }
        return map;
    }

    private static IAssemblyFunction[] loadFunctions(JsonArray array) throws JsonParseException {
        return JsonHelper.deserializeInto(array, IAssemblyFunction[]::new, element -> (IAssemblyFunction)GSON.fromJson(element, IAssemblyFunction.class));
    }

    public static final class ItemGroup {
        private final String id;
        private final int weight;
        private final Item[] items;
        private final IAssemblyFunction[] functions;

        ItemGroup(String id, int weight, Item[] items, IAssemblyFunction[] functions) {
            this.id = id;
            this.weight = weight;
            this.items = items;
            this.functions = functions;
        }

        public int getWeight() {
            return this.weight;
        }

        public Item[] getItems() {
            return this.items;
        }

        public IAssemblyFunction[] getFunctions() {
            return this.functions;
        }

        static ItemGroup resolve(JsonElement element) {
            JsonObject object = JsonHelper.asJsonObject(element);
            String id = JSONUtils.func_151200_h((JsonObject)object, (String)"id");
            int weight = JSONUtils.func_151208_a((JsonObject)object, (String)"weight", (int)1);
            Item[] items = JsonHelper.deserializeInto(JSONUtils.func_151214_t((JsonObject)object, (String)"items"), Item[]::new, JsonHelper::resolveItem);
            IAssemblyFunction[] functions = object.has("assemblyFunctions") ? QuestRewardManager.loadFunctions(JSONUtils.func_151214_t((JsonObject)object, (String)"assemblyFunctions")) : null;
            return new ItemGroup(id, weight, items, functions);
        }
    }
}

